within OpenHPL.Tests;
model HPModelKPLin
  parameter Integer n = 24;
  // states
  parameter Integer k = 1;
  // top-level inputs
  parameter Integer l = 1;
  // top-level outputs
  parameter Real x0[24] = {992883.289524717, 1408615.924274521, 1824332.096601278, 2240035.212738176, 2655723.668014717, 3071397.894367104, 3487057.05338595, 3902700.583697127, 4318331.137879058, 4733948.8193478, 19059.21032479101, 19059.2294580422, 19059.28066128324, 19059.33055236392, 19059.37895675784, 19059.41769211072, 19059.43803782915, 19059.43604833334, 19059.41697346472, 19059.36501028928, 3647704893.790293, 3.833941085834154e-005, 738231.8616973314, 262866589.5593565};
  parameter Real u0 = 0.7493;
  parameter Real A[24, 24] = [-16.08439026907414, 15.86292760442456, -4.794393543600575, 0.3011297796144339, 0, 0, 0, 0, 0, 0, 2188.559966173648, -2314.193716402733, 169.493858252066, -42.37346456301649, 7.402878769272996e-015, 0, 0, 0, 0, 0, 1.567153511469892e-005, -183.3864295134294, 4.21509388076372, 0; 4.168167842729975, -10.42053917969667, 8.336574804532114, -2.084203479028384, 0, 0, 0, 0, 0, 0, 2122.861322710982, -1239.860505712094, -1177.334420838401, 294.3336052096002, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0; -2.084203479524912, 8.337052903895106, -12.5059378308296, 8.337530874422105, -2.084442465054391, 0, 0, 0, 0, 0, -767.3357814221653, 2537.314910450359, -297.5151423987605, -1766.797802929313, 294.3338151761125, 0, 0, 0, 0, 0, 0, 0, 0, 0; 0, -2.084442464823843, 8.338008721745783, -12.5073713779712, 8.338486447316516, -2.084681327441733, 0, 0, 0, 0, 0, -295.1289370152623, 1769.97829035952, -2.384735796900835, -1766.798642407185, 294.3340250271784, 0, 0, 0, 0, 0, 0, 0, 0; 0, 0, -2.084681327504803, 8.338964047758481, -12.50880417768666, 8.339441523458587, -2.084920065299463, 0, 0, 0, 0, 0, -295.1287271223586, 1769.97745093536, 291.9507575560861, -2532.068491438651, 765.2690102092555, 0, 0, 0, 0, 0, 0, 0; 0, 0, 0, -2.084920065181, 8.339918873750815, -12.51023623091876, 8.340396100586061, -2.085158678403219, 0, 0, 0, 0, 0, -295.1285174187467, 1180.514069674987, 1824.554835822752, -2709.94038779626, 0, 0, 0, 0, 0, 0, 0; 0, 0, 0, 0, -2.085158678326279, 8.340873200302626, -12.51166753186883, 8.341350173085219, -2.085397165020682, 0, 0, 0, 0, 0, 0, 413.179630588721, -1.111114578572111, -412.0685166606934, 0, 0, 0, 0, 0, 0; 0, 0, 0, 0, 0, -2.085397165400728, 8.341827024754881, -12.51309807921205, 8.342303749490215, -2.085635528160546, 0, 0, 0, 0, 0, 0, 2713.114999205013, -2301.046188621637, -412.0688109738587, 0, 0, 0, 0, 0; 0, 0, 0, 0, 0, 0, -2.08563552817265, 8.342780352912506, -10.4286541249092, 4.171509292868229, 0, 0, 0, 0, 0, 0, -767.3325070394367, 3480.446666071489, -2124.444009216493, -588.6701504947939, 0, 0, 0, 0; 0, 0, 0, 0, 0, 0, 0.4648693157161499, -6.269293279834859, 19.96673987447301, -16.93848668072003, 0, 0, 0, 0, 0, 0, 171.1055975833029, -1716.901645469861, 4333.166137996929, -1398.740070444036, 0, 0, 0, 0.0004888870995462002; 0.03349447058525149, -0.06455160773185904, -0.004471687688911441, 0.002132750452394769, 0, 0, 0, 0, 0, 0, 1.344613064293004, -2.275267967984701, 1.200439569039228, -0.3001098922598071, 5.243085909472713e-017, 0, 0, 0, 0, 0, 1.10993584388731e-007, -1.298833649095132, 0.02985338544927606, 0; 0.05902588289657602, 0.01466154432942627, -0.08842311557761337, 0.01473167638255253, 0, 0, 0, 0, 0, 0, 4.249612493222614, -10.50934525646588, 8.291868946992661, -2.072967236748165, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0; -0.01477149400629437, 0.08859589992217727, -0.0001031640495938163, -0.08846365467600036, 0.01473843269475015, 0, 0, 0, 0, 0, -5.44822222013016, 13.85283973256269, -14.64232078941463, 8.270106269852134, -2.073210860905721, 0, 0, 0, 0, 0, 0, 0, 0, 0; 0, -0.01477824751444726, 0.08863641976388749, -0.0001031361401604561, -0.08850416969936603, 0.01474518499831691, 0, 0, 0, 0, 0, -2.095704410518916, 8.405545390902315, -12.54826087872316, 8.271089679051151, -2.073454356969451, 0, 0, 0, 0, 0, 0, 0, 0; 0, 0, -0.01478499701134827, 0.08867691551946535, -0.0001031081395734883, -0.08854466065682946, 0.0147519332956893, 0, 0, 0, 0, 0, -2.095938609732372, 8.406472767731195, -14.62336804918776, 13.66368666985718, -5.391614090380772, 0, 0, 0, 0, 0, 0, 0; 0, 0, 0, -0.01479174247575537, 0.08871738710462698, -0.00010308006059185, -0.08858512758031897, 0.01475867759467838, 0, 0, 0, 0, 0, -2.096172685771156, 8.384690743084622, -14.56597681475787, 8.236720752045791, 0, 0, 0, 0, 0, 0, 0; 0, 0, 0, 0, -0.01479848390591617, 0.08875783449672599, -0.0001030517771802353, -0.08862557044123512, 0.01476541789204345, 0, 0, 0, 0, 0, 0, 2.934969285282572, -5.879541666524696, 2.903857761092998, 0, 0, 0, 0, 0, 0; 0, 0, 0, 0, 0, -0.01480522127838294, 0.08879825762278153, -0.0001030234412715021, -0.088665989336792, 0.01477215420688555, 0, 0, 0, 0, 0, 0, 8.445555805603728, -11.39044508536888, 2.904197983285988, 0, 0, 0, 0, 0; 0, 0, 0, 0, 0, 0, -0.01481195461720632, 0.0888386566422107, -0.01488188161274545, -0.05914861119676303, 0, 0, 0, 0, 0, 0, -5.451872731693405, 13.89833866605086, -12.63647389474842, 4.149340070385929, 0, 0, 0, 0; 0, 0, 0, 0, 0, 0, -0.003294827433872963, 0.01483189719198888, 0.03610530131727136, -0.0279696253825127, 0, 0, 0, 0, 0, 0, -1.212735274080617, 1.277730315488761, 5.358193366035733, -15.305945749619, 0, 0, 0, -3.465056894903684e-006; 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0; -2.006946570338033e-005, 0.0001008453303547595, -3.63111738390832e-005, 4.0341861259126e-006, 0, 0, 0, 0, 0, 0, 9.791739439189312e-005, -0.001781012078079036, 0.002270681339664842, -0.0005676703349162106, -8.244914809464768e-020, 0, 0, 0, 0, 0, 2.099489781861486e-010, -0.002459268912785462, -4.694537225848162e-005, 0; 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 997, 0, 0; 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0];
  parameter Real B[24, 1] = [0; 0; 0; 0; 0; 0; 0; 0; 0; -35379147.78627282; 0; 0; 0; 0; 0; 0; 0; 0; 0; 250754.7449839309; 0; 0; 0; 0];
  parameter Real C[1, 24] = [0, 0, 0, 0, 0, 0, -4.771649985545624e-010, 4.294069962565973e-009, -1.193018801645569e-008, 2.397726670543185e-009, 0, 0, 0, 0, 0, 0, -1.756312999444499e-007, 9.746855769994258e-007, -0.0005010485766950694, 0.001499653183721549, 0, 0, 0, -5.018180470546436e-013];
  parameter Real D[1, 1] = [0.03631491783081359];
  Real x[24](start = x0);
  input Real u(start = u0);
  output Real y[1];
equation
  der(x) = A * x + B * u * ones(1);
  y = C * x + D * u * ones(1);
end HPModelKPLin;
